jQuery(document).ready(function () {
	if(!estadoCierreRealizado){
		$("#gestionarDocs_toolbar").rup_toolbar({
			buttons:
				[{id:"GuardarObservaciones", i18nCaption:$.rup.i18n.app.botones.Guardar, left:true, click:guardarObservaciones}]
		});
		$("#ftramitacion014Str").rup_date({datetimepicker: false});
	}else{
		$("#observaciones014").attr("readonly", true);
		$("#ftramitacion014Str").attr("readonly", true);
	}
	
	$("#cierre_form").rup_validate({
		feedback:$("#tramitacion_feedback"),
		liveCheckingErrors: true,
		rules:{
			"ftramitacion014Str":{required:true,date:true}
		}
	});
});	

//Funcion que serializa el Expediente para ser enviado
function serializeExpediente(){
	return $("#cierre_form").rup_form('formToJson');
}

function guardarObservaciones(){
	// Llamada ajax para Guardar

	if(ab03bUtils.form.validate($("#cierre_form"), $("#tramitacion_feedback"))){
		$.rup_ajax({
			url:  $.rup.CTX_PATH +"ab03b14t00/guardar",
			type: "POST",
			data: JSON.stringify(serializeExpediente()),
			dataType: 'json',
			contentType: 'application/json',
			success: function (mapaRespuesta){
				ab03bUtils.feedback.pintarFeedback($.rup.i18nParse($.rup.i18n.app,"mensajes.okGenerico"),  "ok",$("#tramitacion_feedback"));
			},
			error: function(error){
				pintarFeedbackError(error.responseText, $("#tramitacion_feedback"));
			},
			beforeSend :  function() {
				ab03bUtils.util.bloquearInterfaz();
			},
			complete: function() {
				ab03bUtils.util.desBloquearInterfaz();
			}
		});
	} 
}